#!/bin/env ruby
# encoding: utf-8
require 'rubygems'
require 'rspec'
require 'watir-webdriver'
require 'page-object'

require_relative '../module/DriverUtility'
require_relative './rspec_helper'
require_relative '../pages/landing'
require_relative '../pages/login'
require_relative '../pages/eula'
require_relative '../common/common'
require_relative '../pages/roa'

describe '[App Foundation: Landing, Login, Eula]' do
  include DriverUtility

  before(:all) do
    initializeConfigurations(VAR_BASE_URL)
    @landing = Landing.new(@driver)
    @login = Login.new(@driver)
    @eula = Eula.new(@driver)
    @roa = Roa.new(@driver)
    @common = Common.new(@driver)
  end

  after(:all) do
    @driver.close
  end

  context 'Landing Screen' do
    xit "EULA" do
      Watir::Wait.until {@eula.accept_element.exists?}
      @eula.accept_element.when_present(TIME_OUT_LIMIT)
      expect(@eula.has_expected_title?).to eq(true)
      expect(@eula.accept_element.present?).to eq(true)
      @common.waitWhileSpinnerPresent

      @eula.accept_element.click
      @common.waitWhileSpinnerPresent
    end

    xit "Login Button" do
      @landing.login_element.when_visible(TIME_OUT_LIMIT)
      expect(@landing.has_expected_title?).to eq(true)
      expect(@landing.login_element.visible?).to eq(true)
#      expect(@landing.launchPad_element.visible?).to eq(true)
    end

    xit "Login screen " do
      @landing.login
      @login.login_element.when_visible(TIME_OUT_LIMIT)

      expect(@login.has_expected_title?).to eq(true)
     # @login.login_with("zztest.patient01", "pass", "D123401")
      @login.login_without_passing_ROA("zztest.patient01", "pass", "D123401")
    end

    xit "ROA" do
      @roa.nextButton_element.when_visible(TIME_OUT_LIMIT)
      expect(@roa.has_expected_title?).to eq(true)
      @roa.nextButton_element.when_present(TIME_OUT_LIMIT)
      @roa.nextButton

      @roa.verify_element.when_present(TIME_OUT_LIMIT)
      @roa.verify
    end

    xit "Logged in" do
      @common.waitWhileSpinnerPresent
      @landing.footerUserInfo_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing.footerUserInfo == "Logged in as patient01, zztest"}
      expect(@landing.footerUserInfo).to eq("Logged in as patient01, zztest")
      expect(@landing.appVersion).to eq("VA Appointments - v4.10.0")
    end
  end
end





